-- Slightly less immediately functional parts of this screen.
local profile = GAMESTATE:GetEditLocalProfile()
local profileID = GAMESTATE:GetEditLocalProfileID()

-- Copypasta from SelectProfile
local function GetSongsPlayedString(numSongs)
	return numSongs == 1 and THEME:GetString("ScreenSelectProfile", "SingularSongPlayed") or THEME:GetString("ScreenSelectProfile", "SeveralSongsPlayed")
end

local t = Def.ActorFrame {
	-- Pane base.
	Def.Quad {
		InitCommand=cmd(horizalign,left;vertalign,top;zoomto,_screen.w,140;diffuse,LocalBlueColor(0))
	},
	
	-- Oh boy, AVATARS (again)
	Def.Quad {
		InitCommand=function(self)
			self:xy(60,88):zoomto(96+12,96+12):rotationz(1):diffuse(LocalGoldColor(1))
		end,
	},
	Def.Quad {
		InitCommand=function(self)
			self:xy(60,88):zoomto(96+6,96+6):diffuse(LocalGoldColor(0.25))
		end,
	},
	Def.Sprite {
		OnCommand=function(self)
			local foxAv = LoadModule("Config.Load.lua")( "AvatarImage", "/Save/LocalProfiles/"..profileID.."/OutFoxPrefs.ini" )
			
			self:LoadBanner(foxAv or THEME:GetPathG("UserProfile", "generic icon"))
			self:xy(60,88):zoomto(96,96)
		end
	},
	
	LoadFont("Common Small") .. {
		Text="selected profile",
		InitCommand=function(self)
			self:xy(124,40):strokecolor(Color.Black):horizalign(left):zoom(0.4):diffuse(LocalBlueColor(1))
		end
	},
	
	-- Profile name.
	LoadFont("Common Normal") .. {
		Text=profile:GetDisplayName(),
		InitCommand=function(self)
			self:xy(124,60):strokecolor(Color.Black):horizalign(left):zoom(0.8):maxwidth(_screen.w*0.95)
		end
	},
	-- Songs played.
	LoadFont("Common Normal") .. {
		InitCommand=function(self)
			self:xy(124,94):zoom(0.5):strokecolor(Color.Black):horizalign(left):maxwidth((_screen.w*0.95) / 0.5)
			local numSongsPlayed = profile:GetNumTotalSongsPlayed()
			self:settext( string.format( GetSongsPlayedString( numSongsPlayed ), numSongsPlayed ) )
		end
	},
}

t[#t+1] = LoadFallbackB()

return t
